#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QLineSeries>
#include <QChartView>
#include <QChart>
#include <QAbstractAxis>
#include <QDebug>
#include <string>
#include <QPalette>
#include "serialread.h"
#include <QSerialPortInfo>
#include <QTimer>
#include "FFT.h"
#include <math.h>
#include <QScatterSeries>

QT_BEGIN_NAMESPACE
namespace Ui { class MainWindow; }
QT_END_NAMESPACE

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = nullptr);
    ~MainWindow();

signals:
    void signalCreateSerialPort(QString ComPortName);
    void signalSetTimer(bool enable);
    void signalDisconnect();

private slots:
    void on_pushButtonConnectSensor1_clicked();
    void slotReceiveDataFromSerialRead(QStringList buffer_split);
    void on_spinBoxThreshold_valueChanged(int arg1);

    void on_pushButtonRefresh_clicked();

private:
    Ui::MainWindow *ui;
    QtCharts::QScatterSeries *series_marker;
    QtCharts::QLineSeries *series1;
    QtCharts::QLineSeries *series2;
    QtCharts::QLineSeries *series3;
    QtCharts::QChart *chart;
    QtCharts::QChart *chart2;
    QMenuBar *menuBar;
    QPalette darkPalette;
    serialread *mySerial1;
    int threshold;                  //Schwellenwert
    void RefreshComPorts();

};
#endif // MAINWINDOW_H
